
/* copyright 1991-96 UserLand Software, Inc. All Rights Reserved.*/


#ifndef iowaruntimeinclude
#define iowaruntimeinclude

#ifndef iowacoreinclude

	#include "iowacore.h"

#endif


#define iowaInitEvent 1000 /*constants for (*ev).what in callbacks*/
#define iowaButtonHitEvent 1001
#define iowaCloseEvent 1002
#define iowaRunScriptEvent 1003
#define iowaCancelEvent 1004 
#define iowaSetHandleEvent 1005
#define iowaOkeyDokeyEvent 1006 /*dmb 1.0b21*/


typedef boolean (*tycardwindowvisitroutine) (WindowPtr);

typedef void (*tycardeventcallback) (EventRecord *); 


typedef struct tyruntimerecord {
	
	hdlcard hc; /*the unpacked version of the card*/
	
	WindowPtr macwindow; /*the window used to display the card*/
	
	boolean initfields; /*set true when the card starts up, consumed when the first event comes in*/
	
	boolean modeless; /*true if it's a modeless card, false if modal*/
	
	boolean closethiswindow; /*if true it's time to close this card's window*/
	
	boolean ownwindow; /*if true we created this window*/
	
	tycardeventcallback callback; /*a C routine that events filter thru*/
	} tyruntimerecord, **hdlruntimerecord;


extern hdlruntimerecord runtimedata;

extern boolean flquickrecalc; /*set false in cardrunner.c, under special circumstances*/

extern boolean flexitcardloop; /*for modal cards, the loop should exit if true*/

extern boolean flalertdialogrunning; /*prevent nested alerts*/


boolean initIowaRuntime (void);

WindowPtr newCardWindow (Point, boolean, Handle);

boolean handleCardEvent (WindowPtr w, EventRecord *, boolean *);

boolean cardEditCommand (short);

boolean isCardWindow (WindowPtr);

boolean cardToFront (bigstring);

boolean recalcCardWindow (WindowPtr, boolean);

boolean visitCardWindows (tycardwindowvisitroutine);

short countCardWindows (void);

boolean closeCardWindow (WindowPtr);

void closeAllCardWindows (void);

void getCardData (WindowPtr, hdlruntimerecord *); 

boolean isModelessCardEvent (EventRecord *, boolean *);

boolean cardIsModal (Handle);

void installRuntimeEventHandlers (void); /*1.0b20 dmb*/

boolean runModalCard (Handle, boolean, short, short, tycardeventcallback);

boolean runModelessCard (Handle, boolean, short, short, tycardeventcallback);

boolean runCard (Handle, boolean, short, short, tycardeventcallback);

boolean runHostedCard (WindowPtr hostwindow, Handle hpackedcard, boolean flscriptedcard, tycardeventcallback callback);

boolean setObjectValue (hdlcard, bigstring, Handle);

boolean getObjectValue (hdlcard, bigstring, Handle *);

boolean getObjectHandle (hdlcard, bigstring, hdlobject *);

boolean recalcObject (hdlobject);

boolean updateCard (hdlcard);

WindowPtr getcardrecordwindow (hdlcard card);

#endif
